﻿using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.ViaLogin
{
    public class GetIntegrationSettingsStep : FilterBase<ViaLoginStateObject>
    {
        public override void Execute(ViaLoginStateObject state)
        {

            var errorString = string.Format(Strings.IntegrationSettingsErrorString, "{0}", "Get Consults For Patient");
            var fakeResponseString = Strings.ViaLoginFakeResponseType;

            using (var _service = new Xrm(state.OrganizationServiceProxy))
            {
                var via_fakeresponse = _service.mcs_integrationsettingSet.FirstOrDefault(i => i.mcs_name == fakeResponseString);
                if (via_fakeresponse == null)
                {
                    state.FakeResponseType = string.Empty;
                }
                else
                {
                    state.FakeResponseType = via_fakeresponse.mcs_value;
                }
            }
        }
    }
}
